package com.ejie.ab04b.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab04b.constantes.Constantes;
import com.ejie.ab04b.dao.comun.UtilDAO;
import com.ejie.ab04b.model.Promotor;
import com.ejie.ab04b.model.nora.Municipio;
import com.ejie.ab04b.model.nora.Provincia;
import com.ejie.x38.dao.RowNumResultSetExtractor;
import com.ejie.x38.dto.JQGridManager;
import com.ejie.x38.dto.JQGridManagerJerarquia;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JerarquiaDto;
import com.ejie.x38.dto.TableRowDto;

/**
 * Ab0485s00DaoImpl generated by UDA, 21-feb-2017 13:23:33.
 * 
 * @author UDA
 */

@Repository()
@Transactional()
public class PromotorDaoImpl implements PromotorDao {
	private JdbcTemplate jdbcTemplate;

	private static final String QUERY_SELECT = " SELECT t1.TEREXP_085 TEREXP085, t1.ANOEXP_085 ANOEXP085, t1.NUMEXP_085 NUMEXP085, t1.TIPDOC_085 TIPDOC085, "
			+ " t1.NUMDOC_085 NUMDOC085, t1.FECALT_085 FECALT085, t1.TIPOPRM_085 TIPOPRM085, t1.CODOBRA_085 CODOBRA085, t1.FECBAJ_085 FECBAJ085, t1.NOMPRM_085 NOMPRM085,  "
			+ " t1.PAISPRM_085 PAISPRM085, t1.PRVPRM_085 PRVPRM085, t1.MUNPRM_085 MUNPRM085, t1.DMUNPRM_085 DMUNPRM085, t1.DIRPRM_085 DIRPRM085, t1.CPOPRM_085 CPOPRM085,  "
			+ " t1.ORDEXP_085 ORDEXP085, t1.USUALT_085 USUALT085, t1.FECMOD_085 FECMOD085, t1.USUMOD_085 USUMOD085, t1.DESCPRM_085 DESCPRM085, t1.TLFPRM_085 TLFPRM085, t1.EMAILPRM_085 EMAILPRM085, "
			+ " PROVINCIA.ID ID_PROVINCIA, PROVINCIA.DS_O PROVINCIA, MUNICIPIO.ID ID_MUNICIPIO, MUNICIPIO.DS_O MUNICIPIO "
			+ " FROM AB0485S00  t1 LEFT OUTER JOIN PROVINCIA ON (ID = t1.PRVPRM_085) LEFT OUTER JOIN MUNICIPIO ON (MUNICIPIO.PROVINCIA_ID = t1.PRVPRM_085 AND MUNICIPIO.ID = t1.MUNPRM_085) ";

	/*
	 * ROW_MAPPERS
	 */
	private RowMapper<Promotor> rwMap = new RowMapper<Promotor>() {
		public Promotor mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			Promotor promRet = new Promotor(resultSet.getString("TEREXP085"),
					resultSet.getString("ANOEXP085"),
					resultSet.getInt("NUMEXP085"),
					resultSet.getString("TIPDOC085"),
					resultSet.getString("NUMDOC085"),
					resultSet.getDate("FECALT085"),
					resultSet.getString("TIPOPRM085"),
					resultSet.getLong("CODOBRA085"),
					resultSet.getDate("FECBAJ085"),
					resultSet.getString("NOMPRM085"),
					resultSet.getString("PAISPRM085"),
					resultSet.getString("PRVPRM085"),
					resultSet.getString("MUNPRM085"),
					resultSet.getString("DMUNPRM085"),
					resultSet.getString("DIRPRM085"),
					resultSet.getString("CPOPRM085"),
					resultSet.getLong("ORDEXP085"),
					resultSet.getString("USUALT085"),
					resultSet.getDate("FECMOD085"),
					resultSet.getString("USUMOD085"),
					resultSet.getString("DESCPRM085"),
					resultSet.getString("TLFPRM085"),
					resultSet.getString("EMAILPRM085"));

			if (UtilDAO.hasColumn(resultSet, "ID_PROVINCIA")) {
				Provincia prov = new Provincia();
				prov.setCodProvincia(resultSet.getString("ID_PROVINCIA"));
				prov.setDescripcion(resultSet.getString("PROVINCIA"));
				promRet.setProvincia(prov);
			}

			if (UtilDAO.hasColumn(resultSet, "ID_MUNICIPIO")) {
				Municipio munic = new Municipio();
				munic.setCodMunicipio(resultSet.getString("ID_MUNICIPIO"));
				munic.setDescripcion(resultSet.getString("MUNICIPIO"));
				promRet.setMunicipio(munic);
			}

			return promRet;

		}
	};

	private RowMapper<Promotor> rwMapPK = new RowMapper<Promotor>() {
		public Promotor mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new Promotor(resultSet.getString("TEREXP085"),
					resultSet.getString("ANOEXP085"),
					resultSet.getInt("NUMEXP085"),
					resultSet.getString("TIPDOC085"),
					resultSet.getString("NUMDOC085"),
					resultSet.getDate("FECALT085"),
					resultSet.getString("TIPOPRM085"));
		}
	};

	/**
	 * Rowmapper para Jerarquía
	 * 
 dataSource
	 *            DataSource

	 */
	private RowMapper<JerarquiaDto<Promotor>> rwMapJerarquia = new RowMapper<JerarquiaDto<Promotor>>() {
		public JerarquiaDto<Promotor> mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {

			Promotor ab0485s00 = new Promotor(resultSet.getString("TEREXP085"),
					resultSet.getString("ANOEXP085"),
					resultSet.getInt("NUMEXP085"),
					resultSet.getString("TIPDOC085"),
					resultSet.getString("NUMDOC085"),
					resultSet.getDate("FECALT085"),
					resultSet.getString("TIPOPRM085"),
					resultSet.getLong("CODOBRA085"),
					resultSet.getDate("FECBAJ085"),
					resultSet.getString("NOMPRM085"),
					resultSet.getString("PAISPRM085"),
					resultSet.getString("PRVPRM085"),
					resultSet.getString("MUNPRM085"),
					resultSet.getString("DMUNPRM085"),
					resultSet.getString("DIRPRM085"),
					resultSet.getString("CPOPRM085"),
					resultSet.getLong("ORDEXP085"),
					resultSet.getString("USUALT085"),
					resultSet.getDate("FECMOD085"),
					resultSet.getString("USUMOD085"),
					resultSet.getString("DESCPRM085"),
					resultSet.getString("TLFPRM085"),
					resultSet.getString("EMAILPRM085"));

			JerarquiaDto<Promotor> jerarquia = new JerarquiaDto<Promotor>();
			jerarquia.setModel(ab0485s00);
			jerarquia.setLevel(resultSet.getBigDecimal("LEVEL").intValue());
			jerarquia.setParentNodes(resultSet.getString("PARENTNODES"));
			jerarquia.setIsLeaf(
					Boolean.parseBoolean(resultSet.getString("ISLEAF")));
			jerarquia.setFilter(
					Boolean.parseBoolean(resultSet.getString("FILTER")));
			return jerarquia;
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 *  dataSource            DataSource
	 *
	 * @param dataSource the new data source
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/*
	 * OPERACIONES CRUD
	 */

	/**
	 * Inserts a single row in the Ab0485s00 table.
	 * 
	 *  ab0485s00
	 *            Ab0485s00
	 *  Ab0485s00
	 *
	 * @param ab0485s00 the ab 0485 s 00
	 * @return the promotor
	 */
	public Promotor add(Promotor ab0485s00) {
		String query = "INSERT INTO AB0485S00 (TEREXP_085, ANOEXP_085, NUMEXP_085, TIPDOC_085, NUMDOC_085, TIPOPRM_085, CODOBRA_085, FECBAJ_085, NOMPRM_085, PAISPRM_085, PRVPRM_085, MUNPRM_085, DMUNPRM_085, DIRPRM_085, CPOPRM_085, ORDEXP_085, USUALT_085, FECMOD_085, USUMOD_085, DESCPRM_085, FECALT_085, TLFPRM_085, EMAILPRM_085) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,sysdate,?,?)";

		if (ab0485s00.getTipoprm085() != null
				&& !"".equals(ab0485s00.getTipoprm085())
				&& !Constantes.PROMOTOR_SECUNDARIO
						.equals(ab0485s00.getTipoprm085())) {
			ab0485s00.setTipoprm085(Constantes.PROMOTOR_PRINCIPAL);
		} else {
			ab0485s00.setTipoprm085(Constantes.PROMOTOR_SECUNDARIO);
		}

		this.jdbcTemplate.update(query, ab0485s00.getTerexp085(),
				ab0485s00.getAnoexp085(), ab0485s00.getNumexp085(),
				ab0485s00.getTipdoc085(), ab0485s00.getNumdoc085(),
				ab0485s00.getTipoprm085(), ab0485s00.getCodobra085(),
				ab0485s00.getFecbaj085(), ab0485s00.getNomprm085(),
				ab0485s00.getPaisprm085(),
				(ab0485s00.getCodProvincia() != null)
						? ab0485s00.getCodProvincia()
						: ab0485s00.getPrvprm085(),
				(ab0485s00.getCodMunicipio() != null)
						? ab0485s00.getCodMunicipio()
						: ab0485s00.getMunprm085(),
				ab0485s00.getDmunprm085(), ab0485s00.getDirprm085(),
				ab0485s00.getCpoprm085(), ab0485s00.getOrdexp085(),
				ab0485s00.getUsualt085(), ab0485s00.getFecmod085(),
				ab0485s00.getUsumod085(), ab0485s00.getDescprm085(),
				ab0485s00.getTlfprm085(), ab0485s00.getEmailprm085());
		return ab0485s00;
	}

	/**
	 * Inserts a single row in the Ab0485s00 table.
	 * 
	 *  ab0485s00
	 *            Ab0485s00
	 *  Ab0485s00
	 *
	 * @param ab0485s00 the ab 0485 s 00
	 * @return the promotor
	 */
	public Promotor addFromSolicitud(Promotor ab0485s00) {
		String query = "INSERT INTO AB0485S00 (TEREXP_085, ANOEXP_085, NUMEXP_085, TIPDOC_085, NUMDOC_085, TIPOPRM_085, CODOBRA_085, FECBAJ_085, NOMPRM_085, PAISPRM_085, PRVPRM_085, "
				+ "MUNPRM_085, DMUNPRM_085, DIRPRM_085, CPOPRM_085, ORDEXP_085, USUALT_085, FECMOD_085, USUMOD_085, DESCPRM_085, FECALT_085,TLFPRM_085,EMAILPRM_085) ("
				+ " SELECT ?, ?, ?, TIPDOC_085, NUMDOC_085, TIPOPRM_085, CODOBRA_085, FECBAJ_085, NOMPRM_085, PAISPRM_085, PRVPRM_085, "
				+ " MUNPRM_085, DMUNPRM_085, DIRPRM_085, CPOPRM_085, ORDEXP_085, USUALT_085, FECMOD_085, USUMOD_085, DESCPRM_085, SYSDATE,TLFPRM_085,EMAILPRM_085 FROM AB0485S01 WHERE CODOBRA_085 = ? "
				+ ")";

		this.jdbcTemplate.update(query, ab0485s00.getTerexp085(),
				ab0485s00.getAnoexp085(), ab0485s00.getNumexp085(),
				ab0485s00.getCodobra085());
		return ab0485s00;
	}

	/**
	 * Updates a single row in the Ab0485s00 table.
	 * 
	 *  ab0485s00
	 *            Ab0485s00
	 *  Ab0485s00
	 *
	 * @param ab0485s00 the ab 0485 s 00
	 * @return the promotor
	 */
	public Promotor update(Promotor ab0485s00) {
		String query = "UPDATE AB0485S00 SET NOMPRM_085=?, PAISPRM_085=?, PRVPRM_085=?, MUNPRM_085=?, DMUNPRM_085=?, DIRPRM_085=?, CPOPRM_085=?, FECMOD_085=?, DESCPRM_085=?, TIPOPRM_085=? , TLFPRM_085=? , EMAILPRM_085=? WHERE TEREXP_085=? AND ANOEXP_085=? AND NUMEXP_085=? AND TIPDOC_085=? AND NUMDOC_085=? ";

		if (ab0485s00.getTipoprm085() != null
				&& !"".equals(ab0485s00.getTipoprm085())
				&& !Constantes.PROMOTOR_SECUNDARIO
						.equals(ab0485s00.getTipoprm085())) {
			ab0485s00.setTipoprm085(Constantes.PROMOTOR_PRINCIPAL);
		} else {
			ab0485s00.setTipoprm085(Constantes.PROMOTOR_SECUNDARIO);
		}

		this.jdbcTemplate.update(query, ab0485s00.getNomprm085(),
				ab0485s00.getPaisprm085(),
				(ab0485s00.getCodProvincia() != null)
						? ab0485s00.getCodProvincia()
						: ab0485s00.getPrvprm085(),
				(ab0485s00.getCodMunicipio() != null)
						? ab0485s00.getCodMunicipio()
						: ab0485s00.getMunprm085(),
				ab0485s00.getDmunprm085(), ab0485s00.getDirprm085(),
				ab0485s00.getCpoprm085(), new Date(), ab0485s00.getDescprm085(),
				ab0485s00.getTipoprm085(), ab0485s00.getTlfprm085(),
				ab0485s00.getEmailprm085(), ab0485s00.getTerexp085(),
				ab0485s00.getAnoexp085(), ab0485s00.getNumexp085(),
				ab0485s00.getTipdoc085(), ab0485s00.getNumdoc085());
		return ab0485s00;
	}

	/**
	 * Finds a single row in the Ab0485s00 table.
	 * 
	 *  ab0485s00
	 *            Ab0485s00
	 *  Ab0485s00
	 *
	 * @param ab0485s00 the ab 0485 s 00
	 * @return the promotor
	 */
	@Transactional(readOnly = true)
	public Promotor find(Promotor ab0485s00) {
		StringBuilder query = new StringBuilder(
				PromotorDaoImpl.STRING_BUILDER_INIT);
		query.append(PromotorDaoImpl.QUERY_SELECT);
		query.append(
				" WHERE t1.TEREXP_085 = ?   AND t1.ANOEXP_085 = ?   AND t1.NUMEXP_085 = ?   AND t1.TIPDOC_085 = ?   AND t1.NUMDOC_085 = ? ");

		List<Promotor> ab0485s00List = this.jdbcTemplate.query(query.toString(),
				this.rwMap, ab0485s00.getTerexp085(), ab0485s00.getAnoexp085(),
				ab0485s00.getNumexp085(), ab0485s00.getTipdoc085(),
				ab0485s00.getNumdoc085());
		return (Promotor) DataAccessUtils.uniqueResult(ab0485s00List);
	}

	/**
	 * Finds a single row in the Ab0483s00 table.
	 * 
	 *  ab0485s00
	 *            Promotor
	 *  List<Promotor>
	 *
	 * @param ab0485s00 the ab 0485 s 00
	 * @return the list
	 */
	@Transactional(readOnly = true)
	public List<Promotor> findPromotorMaxFecAlta(Promotor ab0485s00) {
		StringBuilder select = new StringBuilder(
				PromotorDaoImpl.STRING_BUILDER_INIT);
		select.append(PromotorDaoImpl.QUERY_SELECT);
		select.append("WHERE t1.TIPDOC_085 = ? AND t1.NUMDOC_085 = ? ");
		select.append("ORDER BY t1.FECALT_085 DESC");

		return (List<Promotor>) this.jdbcTemplate.query(select.toString(),
				this.rwMap, ab0485s00.getTipdoc085(), ab0485s00.getNumdoc085());
	}

	/**
	 * Counts rows in the Personas table.
	 * 
	 *  ab0485s00
	 *            Promotor
	 *  Long
	 *
	 * @param ab0485s00 the ab 0485 s 00
	 * @return the long
	 */
	@Transactional(readOnly = true)
	public long buscarHayPromotorPrincipal(Promotor ab0485s00) {
		StringBuilder query = new StringBuilder(
				"SELECT  count(*) from AB0485S00 t1 ");
		query.append(
				" WHERE t1.TEREXP_085 = ?   AND t1.ANOEXP_085 = ?   AND t1.NUMEXP_085 = ?   AND t1.CODOBRA_085 = ? AND t1.TIPOPRM_085 = ?  ");

		return this.jdbcTemplate.queryForLong(query.toString(),
				ab0485s00.getTerexp085(), ab0485s00.getAnoexp085(),
				ab0485s00.getNumexp085(), ab0485s00.getCodobra085(),
				ab0485s00.getTipoprm085());

	}

	/**
	 * Removes a single row in the Ab0485s00 table.
	 * 
	 *  ab0485s00            Ab0485s00
	 *
	 * @param ab0485s00 the ab 0485 s 00
	 */
	public void remove(Promotor ab0485s00) {
		String query = "DELETE FROM AB0485S00 WHERE TEREXP_085=? AND ANOEXP_085=? AND NUMEXP_085=? AND TIPDOC_085=? AND NUMDOC_085=?  AND CODOBRA_085 = ? ";
		this.jdbcTemplate.update(query, ab0485s00.getTerexp085(),
				ab0485s00.getAnoexp085(), ab0485s00.getNumexp085(),
				ab0485s00.getTipdoc085(), ab0485s00.getNumdoc085(),
				ab0485s00.getCodobra085());
	}

	/**
	 * Finds a list of rows in the Ab0485s00 table.
	 * 
	 *  ab0485s00
	 *            Ab0485s00
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  List<Ab0485s00>
	 *
	 * @param ab0485s00 the ab 0485 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @return the list
	 */
	@Transactional(readOnly = true)
	public List<Promotor> findAll(Promotor ab0485s00,
			JQGridRequestDto jqGridRequestDto) {
		StringBuilder query = new StringBuilder(
				PromotorDaoImpl.STRING_BUILDER_INIT);
		query.append(PromotorDaoImpl.QUERY_SELECT);

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(ab0485s00);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}

		return (List<Promotor>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Finds rows in the Ab0485s00 table using like.
	 * 
	 *  ab0485s00
	 *            Ab0485s00
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  List<Ab0485s00>
	 *
	 * @param ab0485s00 the ab 0485 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the list
	 */
	@Transactional(readOnly = true)
	public List<Promotor> findAllLike(Promotor ab0485s00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				PromotorDaoImpl.STRING_BUILDER_INIT);
		query.append(PromotorDaoImpl.QUERY_SELECT);

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(ab0485s00, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}

		return (List<Promotor>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Counts rows in the Ab0485s00 table.
	 * 
	 *  ab0485s00
	 *            Ab0485s00
	 *  Long
	 *
	 * @param ab0485s00 the ab 0485 s 00
	 * @return the long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(Promotor ab0485s00) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM AB0485S00 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(ab0485s00);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Counts rows in the Ab0485s00 table using like.
	 * 
	 *  ab0485s00
	 *            Ab0485s00
	 *  startsWith
	 *            Boolean
	 *  Long
	 *
	 * @param ab0485s00 the ab 0485 s 00
	 * @param startsWith the starts with
	 * @return the long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(Promotor ab0485s00, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM AB0485S00 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(ab0485s00, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Reorder the data list of Ab0485s00 selected for rup_table.
	 * 
	 *  ab0485s00            Ab0485s00
	 *  jqGridRequestDto            JQGridRequestDto
	 *  startsWith            Boolean
	 *  List<TableRowDto<Ab0485s00>>
	 *
	 * @param ab0485s00 the ab 0485 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the list
	 */
	@Override
	public List<TableRowDto<Promotor>> reorderSelection(Promotor ab0485s00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				PromotorDaoImpl.STRING_BUILDER_INIT);
		query.append(PromotorDaoImpl.QUERY_SELECT);
		// FILTRADO
		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(ab0485s00, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		// Parámetros de filtrado
		@SuppressWarnings("unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhere.get("params");

		// SQL para la reordenación
		StringBuilder sbReorderSelectionSQL = JQGridManager.getReorderQuery(
				query, jqGridRequestDto, Promotor.class, filterParamList,
				"TEREXP_085,ANOEXP_085,NUMEXP_085,TIPDOC_085,NUMDOC_085,FECALT_085,TIPOPRM_085");

		return this.jdbcTemplate.query(sbReorderSelectionSQL.toString(),
				new RowNumResultSetExtractor<Promotor>(this.rwMapPK,
						jqGridRequestDto),
				filterParamList.toArray());
	}

	/**
	 * Search method for rup_table.
	 * 
	 *  filterParams            Ab0485s00
	 *  searchParams            Ab0485s00
	 *  jqGridRequestDto            JQGridRequestDto
	 *  startsWith            Boolean
	 *  List<TableRowDto<Ab0485s00>>
	 *
	 * @param filterParams the filter params
	 * @param searchParams the search params
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the list
	 */
	@Override
	public List<TableRowDto<Promotor>> search(Promotor filterParams,
			Promotor searchParams, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {
		// SELECT
		StringBuilder query = new StringBuilder(
				PromotorDaoImpl.STRING_BUILDER_INIT);
		query.append(PromotorDaoImpl.QUERY_SELECT);
		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// FILTRADO
		Map<String, ?> mapaWhereFilter = this.getWhereLikeMap(filterParams,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhereFilter.get("query"));
		query.append(where);
		// Filter params
		@SuppressWarnings("unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhereFilter
				.get("params");

		// BUSQUEDA
		Map<String, Object> mapaWhereSearch = this.getWhereLikeMap(searchParams,
				startsWith);
		String searchSQL = ((StringBuilder) mapaWhereSearch.get("query"))
				.toString();
		// Search params
		@SuppressWarnings("unchecked")
		List<Object> searchParamList = (List<Object>) mapaWhereSearch
				.get("params");

		// SQL
		StringBuilder sbReorderSelectionSQL = JQGridManager.getSearchQuery(
				query, jqGridRequestDto, Promotor.class, filterParamList,
				searchSQL, searchParamList, from_alias,
				"TEREXP_085,ANOEXP_085,NUMEXP_085,TIPDOC_085,NUMDOC_085,FECALT_085,TIPOPRM_085");

		return this.jdbcTemplate.query(sbReorderSelectionSQL.toString(),
				new RowNumResultSetExtractor<Promotor>(this.rwMapPK,
						jqGridRequestDto),
				filterParamList.toArray());
	}

	/**
	 * Remove multiple method for rup_table.
	 * 
	 *  filterab0485s00            Ab0485s00
	 *  jqGridRequestDto            JQGridRequestDto
	 *  startsWith            Boolean
	 *
	 * @param filterab0485s00 the filterab 0485 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 */
	@Override
	public void removeMultiple(Promotor filterab0485s00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				PromotorDaoImpl.STRING_BUILDER_INIT);
		query.append(PromotorDaoImpl.QUERY_SELECT);

		// WHERE
		Map<String, Object> mapaWhere = this.getWhereLikeMap(filterab0485s00,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		@SuppressWarnings("unchecked")
		List<Object> params = (List<Object>) mapaWhere.get("params");

		StringBuilder sbRemoveMultipleSQL = JQGridManager
				.getRemoveMultipleQuery(jqGridRequestDto, Promotor.class, query,
						params,
						"TEREXP_085,ANOEXP_085,NUMEXP_085,TIPDOC_085,NUMDOC_085,FECALT_085,TIPOPRM_085");
		this.jdbcTemplate.update(sbRemoveMultipleSQL.toString(),
				params.toArray());
	}

	/**
	 * Filter in the hierarchical Ab0485s00 table.
	 * 
	 *  filterAb0485s00
	 *            Ab0485s00
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  List<JerarquiaDto<Ab0485s00>>
	 *
	 * @param filterAb0485s00 the filter ab 0485 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @return the list
	 */
	@Override
	public List<JerarquiaDto<Promotor>> findAllLikeJerarquia(
			Promotor filterAb0485s00, JQGridRequestDto jqGridRequestDto) {
		StringBuilder query = new StringBuilder(
				PromotorDaoImpl.STRING_BUILDER_INIT);
		query.append(PromotorDaoImpl.QUERY_SELECT);
		List<String> from = new ArrayList<String>();
		from.add("AB0485S00");
		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// JOINS TABLAS
		/*
		 * Ejemplo de como indicar joins entre las tablas de la query
		 */
		/*
		 * StringBuilder joins = new StringBuilder(""); joins.append(
		 * "AND T1.ID=T2.ID_T1");
		 */

		// CONDICIONES (negocio)
		/*
		 * Ejemplo de como incluir condiciones de negocio en la consulta de la
		 * jerarquía
		 */
		/*
		 * StringBuilder businessFilters = new StringBuilder(); List<Object>
		 * businessParams = new ArrayList<Object>(); businessFilters.append(
		 * "   AND t1.EJIE = ?  "); businessParams.add("1");
		 */

		// FILTRO
		Map<String, ?> mapaWhere = this.getWhereLikeMap(filterAb0485s00, false);

		// JERARQUIA
		// Especificar la columna padre correspondiente en lugar de la generada
		// por defecto (ID_PADRE)
		query = JQGridManagerJerarquia.getQuery(jqGridRequestDto, query,
				mapaWhere,
				"TEREXP_085,ANOEXP_085,NUMEXP_085,TIPDOC_085,NUMDOC_085,FECALT_085,TIPOPRM_085",
				"ID_PADRE", "NOMBRE", from, from_alias);

		/*
		 * Ejemplo de llamada en caso de indicar joins entre tablas y
		 * condiciones de negocio
		 */
		// query = JQGridManagerJerarquia.getQuery(jqGridRequestDto, query,
		// mapaWhere, "ID", "ID_PADRE", "NOMBRE", from, from_alias, joins,
		// businessFilters, businessParams);

		// PAGINACION
		if (jqGridRequestDto != null) {
			query = JQGridManagerJerarquia.getPaginationQuery(jqGridRequestDto,
					query);
		}

		List<?> params = (List<?>) mapaWhere.get("params");
		return this.jdbcTemplate.query(query.toString(), this.rwMapJerarquia,
				params.toArray());
	}

	/**
	 * Count rows in hierarchy.
	 * 
	 *  filterAb0485s00            Ab0485s00
	 *  jqGridRequestDto            JQGridRequestDto
	 *  Long
	 *
	 * @param filterAb0485s00 the filter ab 0485 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @return the long
	 */
	@Override
	public Long findAllLikeCountJerarquia(Promotor filterAb0485s00,
			JQGridRequestDto jqGridRequestDto) {
		// FROM
		// StringBuilder from = new StringBuilder("FROM AB0485S00 t1 ");
		List<String> from = new ArrayList<String>();
		from.add("AB0485S00");

		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// JOINS TABLAS
		/*
		 * Ejemplo de como indicar joins entre las tablas de la query
		 */
		/*
		 * StringBuilder joins = new StringBuilder(""); joins.append(
		 * "AND T1.ID=T2.ID_T1");
		 */

		// CONDICIONES (negocio)
		/*
		 * Ejemplo de como incluir condiciones de negocio en la consulta de la
		 * jerarquía
		 */
		/*
		 * StringBuilder businessFilters = new StringBuilder(); List<Object>
		 * businessParams = new ArrayList<Object>(); businessFilters.append(
		 * "   AND t1.EJIE = ?  "); businessParams.add("1");
		 */

		// FILTRO
		Map<String, ?> mapaWhere = this.getWhereLikeMap(filterAb0485s00, false);

		// JERARQUIA
		// Especificar la columna padre correspondiente en lugar de la generada
		// por defecto (ID_PADRE)
		StringBuilder query = JQGridManagerJerarquia.getQueryCount(
				jqGridRequestDto, mapaWhere,
				"TEREXP_085,ANOEXP_085,NUMEXP_085,TIPDOC_085,NUMDOC_085,FECALT_085,TIPOPRM_085",
				"ID_PADRE", from, from_alias);

		/*
		 * Ejemplo de llamada en caso de indicar joins entre tablas y
		 * condiciones de negocio
		 */
		// StringBuilder query =
		// JQGridManagerJerarquia.getQueryCount(jqGridRequestDto, mapaWhere,
		// "ID", "ID_PADRE", from, from_alias, joins, businessFilters,
		// businessParams);

		List<?> params = (List<?>) mapaWhere.get("params");
		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Find dependent hierarchical rows.
	 * 
	 *  filterAb0485s00            Ab0485s00
	 *  jqGridRequestDto            JQGridRequestDto
	 *  List<TableRowDto<Ab0485s00>>
	 *
	 * @param filterAb0485s00 the filter ab 0485 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @return the list
	 */
	@Override
	public List<TableRowDto<Promotor>> findAllChild(Promotor filterAb0485s00,
			JQGridRequestDto jqGridRequestDto) {

		// FROM
		// StringBuilder from = new StringBuilder("FROM AB0485S00 t1 ");
		List<String> from = new ArrayList<String>();
		from.add("AB0485S00");

		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// JOINS TABLAS
		/*
		 * Ejemplo de como indicar joins entre las tablas de la query
		 */
		/*
		 * StringBuilder joins = new StringBuilder(""); joins.append(
		 * "AND T1.ID=T2.ID_T1");
		 */

		// CONDICIONES (negocio)
		/*
		 * Ejemplo de como incluir condiciones de negocio en la consulta de la
		 * jerarquía
		 */
		/*
		 * StringBuilder businessFilters = new StringBuilder(); List<Object>
		 * businessParams = new ArrayList<Object>(); businessFilters.append(
		 * "   AND t1.EJIE = ?  "); businessParams.add("1");
		 */

		// FILTRO
		Map<String, ?> mapaWhere = this.getWhereLikeMap(filterAb0485s00, false);

		// MULTISELECCION
		// Especificar la columna padre correspondiente en lugar de la generada
		// por defecto (ID_PADRE)
		StringBuilder query = JQGridManagerJerarquia.getQueryChildren(
				jqGridRequestDto, mapaWhere,
				"TEREXP_085,ANOEXP_085,NUMEXP_085,TIPDOC_085,NUMDOC_085,FECALT_085,TIPOPRM_085",
				"ID_PADRE", from, from_alias);

		/*
		 * Ejemplo de llamada en caso de indicar joins entre tablas y
		 * condiciones de negocio
		 */
		// StringBuilder query =
		// JQGridManagerJerarquia.getQueryChildren(jqGridRequestDto, mapaWhere,
		// "ID", "ID_PADRE", from, from_alias, joins, businessFilters,
		// businessParams);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.query(query.toString(),
				new RowNumResultSetExtractor<Promotor>(this.rwMapPK,
						"TEREXP_085,ANOEXP_085,NUMEXP_085,TIPDOC_085,NUMDOC_085,FECALT_085,TIPOPRM_085"),
				params.toArray());
	}

	/*
	 * MÉTODOS PRIVADOS
	 */

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Ab0485s00 entity.
	 * 
	 *  ab0485s00            Ab0485s00 Bean with the criteria values to filter by.
	 *  Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 *
	 * @param ab0485s00 the ab 0485 s 00
	 * @return the where map
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(Promotor ab0485s00) {

		StringBuilder where = new StringBuilder(
				PromotorDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (ab0485s00 != null && ab0485s00.getTerexp085() != null) {
			where.append(" AND t1.TEREXP_085 = ?");
			params.add(ab0485s00.getTerexp085());
		}
		if (ab0485s00 != null && ab0485s00.getAnoexp085() != null) {
			where.append(" AND t1.ANOEXP_085 = ?");
			params.add(ab0485s00.getAnoexp085());
		}
		if (ab0485s00 != null && ab0485s00.getNumexp085() != null) {
			where.append(" AND t1.NUMEXP_085 = ?");
			params.add(ab0485s00.getNumexp085());
		}
		if (ab0485s00 != null && ab0485s00.getTipdoc085() != null) {
			where.append(" AND t1.TIPDOC_085 = ?");
			params.add(ab0485s00.getTipdoc085());
		}
		if (ab0485s00 != null && ab0485s00.getNumdoc085() != null) {
			where.append(" AND t1.NUMDOC_085 = ?");
			params.add(ab0485s00.getNumdoc085());
		}
		if (ab0485s00 != null && ab0485s00.getFecalt085() != null) {
			where.append(" AND t1.FECALT_085 = ?");
			params.add(ab0485s00.getFecalt085());
		}
		if (ab0485s00 != null && ab0485s00.getTipoprm085() != null) {
			where.append(" AND t1.TIPOPRM_085 = ?");
			params.add(ab0485s00.getTipoprm085());
		}
		if (ab0485s00 != null && ab0485s00.getCodobra085() != null) {
			where.append(" AND t1.CODOBRA_085 = ?");
			params.add(ab0485s00.getCodobra085());
		}
		if (ab0485s00 != null && ab0485s00.getFecbaj085() != null) {
			where.append(" AND t1.FECBAJ_085 = ?");
			params.add(ab0485s00.getFecbaj085());
		}
		if (ab0485s00 != null && ab0485s00.getNomprm085() != null) {
			where.append(" AND t1.NOMPRM_085 = ?");
			params.add(ab0485s00.getNomprm085());
		}
		if (ab0485s00 != null && ab0485s00.getPaisprm085() != null) {
			where.append(" AND t1.PAISPRM_085 = ?");
			params.add(ab0485s00.getPaisprm085());
		}
		if (ab0485s00 != null && ab0485s00.getPrvprm085() != null) {
			where.append(" AND t1.PRVPRM_085 = ?");
			params.add(ab0485s00.getPrvprm085());
		}
		if (ab0485s00 != null && ab0485s00.getMunprm085() != null) {
			where.append(" AND t1.MUNPRM_085 = ?");
			params.add(ab0485s00.getMunprm085());
		}
		if (ab0485s00 != null && ab0485s00.getDmunprm085() != null) {
			where.append(" AND t1.DMUNPRM_085 = ?");
			params.add(ab0485s00.getDmunprm085());
		}
		if (ab0485s00 != null && ab0485s00.getDirprm085() != null) {
			where.append(" AND t1.DIRPRM_085 = ?");
			params.add(ab0485s00.getDirprm085());
		}
		if (ab0485s00 != null && ab0485s00.getCpoprm085() != null) {
			where.append(" AND t1.CPOPRM_085 = ?");
			params.add(ab0485s00.getCpoprm085());
		}
		if (ab0485s00 != null && ab0485s00.getOrdexp085() != null) {
			where.append(" AND t1.ORDEXP_085 = ?");
			params.add(ab0485s00.getOrdexp085());
		}
		if (ab0485s00 != null && ab0485s00.getUsualt085() != null) {
			where.append(" AND t1.USUALT_085 = ?");
			params.add(ab0485s00.getUsualt085());
		}
		if (ab0485s00 != null && ab0485s00.getFecmod085() != null) {
			where.append(" AND t1.FECMOD_085 = ?");
			params.add(ab0485s00.getFecmod085());
		}
		if (ab0485s00 != null && ab0485s00.getUsumod085() != null) {
			where.append(" AND t1.USUMOD_085 = ?");
			params.add(ab0485s00.getUsumod085());
		}
		if (ab0485s00 != null && ab0485s00.getDescprm085() != null) {
			where.append(" AND t1.DESCPRM_085 = ?");
			params.add(ab0485s00.getDescprm085());
		}
		if (ab0485s00 != null && ab0485s00.getTlfprm085() != null) {
			where.append(" AND t1.TLFPRM_085 = ?");
			params.add(ab0485s00.getTlfprm085());
		}
		if (ab0485s00 != null && ab0485s00.getEmailprm085() != null) {
			where.append(" AND t1.EMAILPRM_085 = ?");
			params.add(ab0485s00.getEmailprm085());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Ab0485s00 entity.
	 * 
	 *  ab0485s00            Ab0485s00 Bean with the criteria values to filter by.
	 *  startsWith            Boolean
	 *  Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 *
	 * @param ab0485s00 the ab 0485 s 00
	 * @param startsWith the starts with
	 * @return the where like map
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, Object> getWhereLikeMap(Promotor ab0485s00,
			Boolean startsWith) {

		StringBuilder where = new StringBuilder(
				PromotorDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (ab0485s00 != null && ab0485s00.getTerexp085() != null) {
			where.append(" AND UPPER(t1.TEREXP_085) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab0485s00.getTerexp085().toUpperCase() + "%");
			} else {
				params.add("%" + ab0485s00.getTerexp085().toUpperCase() + "%");
			}
			where.append(" AND t1.TEREXP_085 IS NOT NULL");
		}
		if (ab0485s00 != null && ab0485s00.getAnoexp085() != null) {
			where.append(" AND UPPER(t1.ANOEXP_085) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab0485s00.getAnoexp085().toUpperCase() + "%");
			} else {
				params.add("%" + ab0485s00.getAnoexp085().toUpperCase() + "%");
			}
			where.append(" AND t1.ANOEXP_085 IS NOT NULL");
		}
		if (ab0485s00 != null && ab0485s00.getNumexp085() != null) {
			where.append(" AND t1.NUMEXP_085 = ?");
			params.add(ab0485s00.getNumexp085());
		}
		if (ab0485s00 != null && ab0485s00.getTipdoc085() != null) {
			where.append(" AND UPPER(t1.TIPDOC_085) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab0485s00.getTipdoc085().toUpperCase() + "%");
			} else {
				params.add("%" + ab0485s00.getTipdoc085().toUpperCase() + "%");
			}
			where.append(" AND t1.TIPDOC_085 IS NOT NULL");
		}
		if (ab0485s00 != null && ab0485s00.getNumdoc085() != null) {
			where.append(" AND UPPER(t1.NUMDOC_085) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab0485s00.getNumdoc085().toUpperCase() + "%");
			} else {
				params.add("%" + ab0485s00.getNumdoc085().toUpperCase() + "%");
			}
			where.append(" AND t1.NUMDOC_085 IS NOT NULL");
		}
		if (ab0485s00 != null && ab0485s00.getFecalt085() != null) {
			where.append(" AND t1.FECALT_085 = ?");
			params.add(ab0485s00.getFecalt085());
		}
		if (ab0485s00 != null && ab0485s00.getTipoprm085() != null) {
			where.append(" AND UPPER(t1.TIPOPRM_085) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab0485s00.getTipoprm085().toUpperCase() + "%");
			} else {
				params.add("%" + ab0485s00.getTipoprm085().toUpperCase() + "%");
			}
			where.append(" AND t1.TIPOPRM_085 IS NOT NULL");
		}
		if (ab0485s00 != null && ab0485s00.getCodobra085() != null) {
			where.append(" AND t1.CODOBRA_085 = ?");
			params.add(ab0485s00.getCodobra085());
		}
		if (ab0485s00 != null && ab0485s00.getFecbaj085() != null) {
			where.append(" AND t1.FECBAJ_085 = ?");
			params.add(ab0485s00.getFecbaj085());
		}
		if (ab0485s00 != null && ab0485s00.getNomprm085() != null) {
			where.append(" AND UPPER(t1.NOMPRM_085) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab0485s00.getNomprm085().toUpperCase() + "%");
			} else {
				params.add("%" + ab0485s00.getNomprm085().toUpperCase() + "%");
			}
			where.append(" AND t1.NOMPRM_085 IS NOT NULL");
		}
		if (ab0485s00 != null && ab0485s00.getPaisprm085() != null) {
			where.append(" AND UPPER(t1.PAISPRM_085) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab0485s00.getPaisprm085().toUpperCase() + "%");
			} else {
				params.add("%" + ab0485s00.getPaisprm085().toUpperCase() + "%");
			}
			where.append(" AND t1.PAISPRM_085 IS NOT NULL");
		}
		if (ab0485s00 != null && ab0485s00.getPrvprm085() != null) {
			where.append(" AND UPPER(t1.PRVPRM_085) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab0485s00.getPrvprm085().toUpperCase() + "%");
			} else {
				params.add("%" + ab0485s00.getPrvprm085().toUpperCase() + "%");
			}
			where.append(" AND t1.PRVPRM_085 IS NOT NULL");
		}
		if (ab0485s00 != null && ab0485s00.getMunprm085() != null) {
			where.append(" AND UPPER(t1.MUNPRM_085) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab0485s00.getMunprm085().toUpperCase() + "%");
			} else {
				params.add("%" + ab0485s00.getMunprm085().toUpperCase() + "%");
			}
			where.append(" AND t1.MUNPRM_085 IS NOT NULL");
		}
		if (ab0485s00 != null && ab0485s00.getDmunprm085() != null) {
			where.append(" AND UPPER(t1.DMUNPRM_085) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab0485s00.getDmunprm085().toUpperCase() + "%");
			} else {
				params.add("%" + ab0485s00.getDmunprm085().toUpperCase() + "%");
			}
			where.append(" AND t1.DMUNPRM_085 IS NOT NULL");
		}
		if (ab0485s00 != null && ab0485s00.getDirprm085() != null) {
			where.append(" AND UPPER(t1.DIRPRM_085) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab0485s00.getDirprm085().toUpperCase() + "%");
			} else {
				params.add("%" + ab0485s00.getDirprm085().toUpperCase() + "%");
			}
			where.append(" AND t1.DIRPRM_085 IS NOT NULL");
		}
		if (ab0485s00 != null && ab0485s00.getCpoprm085() != null) {
			where.append(" AND UPPER(t1.CPOPRM_085) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab0485s00.getCpoprm085().toUpperCase() + "%");
			} else {
				params.add("%" + ab0485s00.getCpoprm085().toUpperCase() + "%");
			}
			where.append(" AND t1.CPOPRM_085 IS NOT NULL");
		}
		if (ab0485s00 != null && ab0485s00.getOrdexp085() != null) {
			where.append(" AND t1.ORDEXP_085 = ?");
			params.add(ab0485s00.getOrdexp085());
		}
		if (ab0485s00 != null && ab0485s00.getUsualt085() != null) {
			where.append(" AND UPPER(t1.USUALT_085) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab0485s00.getUsualt085().toUpperCase() + "%");
			} else {
				params.add("%" + ab0485s00.getUsualt085().toUpperCase() + "%");
			}
			where.append(" AND t1.USUALT_085 IS NOT NULL");
		}
		if (ab0485s00 != null && ab0485s00.getFecmod085() != null) {
			where.append(" AND t1.FECMOD_085 = ?");
			params.add(ab0485s00.getFecmod085());
		}
		if (ab0485s00 != null && ab0485s00.getUsumod085() != null) {
			where.append(" AND UPPER(t1.USUMOD_085) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab0485s00.getUsumod085().toUpperCase() + "%");
			} else {
				params.add("%" + ab0485s00.getUsumod085().toUpperCase() + "%");
			}
			where.append(" AND t1.USUMOD_085 IS NOT NULL");
		}
		if (ab0485s00 != null && ab0485s00.getDescprm085() != null) {
			where.append(" AND UPPER(t1.DESCPRM_085) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab0485s00.getDescprm085().toUpperCase() + "%");
			} else {
				params.add("%" + ab0485s00.getDescprm085().toUpperCase() + "%");
			}
			where.append(" AND t1.DESCPRM_085 IS NOT NULL");
		}
		if (ab0485s00 != null && ab0485s00.getTlfprm085() != null) {
			where.append(" AND UPPER(t1.TLFPRM_085) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab0485s00.getTlfprm085().toUpperCase() + "%");
			} else {
				params.add("%" + ab0485s00.getTlfprm085().toUpperCase() + "%");
			}
			where.append(" AND t1.TLFPRM_085 IS NOT NULL");
		}
		if (ab0485s00 != null && ab0485s00.getEmailprm085() != null) {
			where.append(" AND UPPER(t1.EMAILPRM_085) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab0485s00.getEmailprm085().toUpperCase() + "%");
			} else {
				params.add(
						"%" + ab0485s00.getEmailprm085().toUpperCase() + "%");
			}
			where.append(" AND t1.EMAILPRM_085 IS NOT NULL");
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;
}
